/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.observable;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableCache<T>
extends AbstractObservableWithUpstream<T, T>
implements Observer<T> {
    final AtomicBoolean once;
    final int capacityHint;
    final AtomicReference<CacheDisposable<T>[]> observers;
    static final CacheDisposable[] EMPTY = new CacheDisposable[0];
    static final CacheDisposable[] TERMINATED = new CacheDisposable[0];
    volatile long size;
    final Node<T> head;
    Node<T> tail;
    int tailOffset;
    Throwable error;
    volatile boolean done;

    public ObservableCache(Observable<T> source, int capacityHint) {
        super(source);
        this.capacityHint = capacityHint;
        this.once = new AtomicBoolean();
        Node n = new Node(capacityHint);
        this.head = n;
        this.tail = n;
        this.observers = new AtomicReference<CacheDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Observer<? super T> t) {
        CacheDisposable<? super T> consumer = new CacheDisposable<T>(t, this);
        t.onSubscribe(consumer);
        this.add(consumer);
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.source.subscribe(this);
        } else {
            this.replay(consumer);
        }
    }

    boolean isConnected() {
        return this.once.get();
    }

    boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    long cachedEventCount() {
        return this.size;
    }

    void add(CacheDisposable<T> consumer) {
        CacheDisposable[] next;
        CacheDisposable<T>[] current;
        do {
            if ((current = this.observers.get()) == TERMINATED) {
                return;
            }
            int n = current.length;
            next = new CacheDisposable[n + 1];
            System.arraycopy(current, 0, next, 0, n);
            next[n] = consumer;
        } while (!this.observers.compareAndSet(current, next));
    }

    void remove(CacheDisposable<T> consumer) {
        CacheDisposable[] next;
        CacheDisposable<T>[] current;
        do {
            int n;
            if ((n = (current = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (current[i] != consumer) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                next = EMPTY;
                continue;
            }
            next = new CacheDisposable[n - 1];
            System.arraycopy(current, 0, next, 0, j);
            System.arraycopy(current, j + 1, next, j, n - j - 1);
        } while (!this.observers.compareAndSet(current, next));
    }

    void replay(CacheDisposable<T> consumer) {
        if (consumer.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        long index = consumer.index;
        int offset = consumer.offset;
        Node node = consumer.node;
        Observer downstream = consumer.downstream;
        int capacity = this.capacityHint;
        while (true) {
            boolean empty;
            if (consumer.disposed) {
                consumer.node = null;
                return;
            }
            boolean sourceDone = this.done;
            boolean bl = empty = this.size == index;
            if (sourceDone && empty) {
                consumer.node = null;
                Throwable ex = this.error;
                if (ex != null) {
                    downstream.onError(ex);
                } else {
                    downstream.onComplete();
                }
                return;
            }
            if (!empty) {
                if (offset == capacity) {
                    node = node.next;
                    offset = 0;
                }
                downstream.onNext(node.values[offset]);
                ++offset;
                ++index;
                continue;
            }
            consumer.index = index;
            consumer.offset = offset;
            consumer.node = node;
            if ((missed = consumer.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
    }

    @Override
    public void onNext(T t) {
        int tailOffset = this.tailOffset;
        if (tailOffset == this.capacityHint) {
            Node n = new Node(tailOffset);
            n.values[0] = t;
            this.tailOffset = 1;
            this.tail.next = n;
            this.tail = n;
        } else {
            this.tail.values[tailOffset] = t;
            this.tailOffset = tailOffset + 1;
        }
        ++this.size;
        for (CacheDisposable<T> consumer : this.observers.get()) {
            this.replay(consumer);
        }
    }

    @Override
    public void onError(Throwable t) {
        this.error = t;
        this.done = true;
        for (CacheDisposable consumer : this.observers.getAndSet(TERMINATED)) {
            this.replay(consumer);
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        for (CacheDisposable consumer : this.observers.getAndSet(TERMINATED)) {
            this.replay(consumer);
        }
    }

    static final class Node<T> {
        final T[] values;
        volatile Node<T> next;

        Node(int capacityHint) {
            this.values = new Object[capacityHint];
        }
    }

    static final class CacheDisposable<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 6770240836423125754L;
        final Observer<? super T> downstream;
        final ObservableCache<T> parent;
        Node<T> node;
        int offset;
        long index;
        volatile boolean disposed;

        CacheDisposable(Observer<? super T> downstream, ObservableCache<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
            this.node = parent.head;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.parent.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

